#include <iostream>
#include <string>
#include <queue>
#include <algorithm>

using namespace std;

typedef int Z;

struct Edge {
	int dest;
	int cap;
	int flow;
	int back;
};

int N, M, K, L, S, T;
vector<vector<Edge>> G;

int verts_per_level;
int verts_total;
int vertexind(int l, int v) {
	return l * verts_per_level + v;
}
int edgeind(int l, int x, int i) {
	return l * verts_per_level + N + 2 * x + i;
}

void addEdge(int a, int b, int cap) {
	if(a == b) return;
	Edge e1{b, cap, 0, (int)G[b].size()};
	Edge e2{a, 0, 0, (int)G[a].size()};
	G[a].push_back(e1);
	G[b].push_back(e2);
}

vector<bool> visited;
int flow = 0;
bool dfs(int s, int t, int vert_limit) {
	if(s >= vert_limit) return false;
	if(visited[s]) return false;
	visited[s] = true;
	if(s == t) {
		++flow;
		return true;
	}
	for(Edge& e : G[s]) {
		if(e.flow == e.cap) continue;
		if(dfs(e.dest, t, vert_limit)) {
			++e.flow;
			--G[e.dest][e.back].flow;
			return true;
		}
	}
	return false;
}

int main() {
	cin.sync_with_stdio(false);
	cin >> N >> M >> K >> S >> T;
	Z L = K + N + 5;
	--S;
	--T;
	verts_per_level = N + 2 * M;
	verts_total = L * verts_per_level;
	G.resize(verts_total);
	
	for(int l = 0; l < L - 1; ++l) {
		for(int v = 0; v < N; ++v) {
			addEdge(vertexind(l, v), vertexind(l + 1, v), K);
		}
	}
	
	vector<pair<int, int>> edges;
	for(int i = 0; i < M; ++i) {
		int a, b;
		cin >> a >> b;
		--a;
		--b;
		edges.emplace_back(a, b);
		for(int l = 0; l < L - 1; ++l) {
			addEdge(vertexind(l, a), edgeind(l, i, 0), K);
			addEdge(vertexind(l, b), edgeind(l, i, 0), K);
			addEdge(edgeind(l, i, 0), edgeind(l, i, 1), 1);
			addEdge(edgeind(l, i, 1), vertexind(l + 1, a), K);
			addEdge(edgeind(l, i, 1), vertexind(l + 1, b), K);
		}
	}
	
	visited.resize(verts_total);
	for(int lvls = 1; lvls < L; ++lvls) {
		flow = 0;
		for(int v = 0; v < verts_total; ++v) {
			for(Edge& e : G[v]) e.flow = 0;
		}
		
		int src = vertexind(0, S);
		int dest = vertexind(lvls, T);
		int vert_limit = (lvls + 1) * verts_per_level;
		
		do {
			fill(visited.begin(), visited.end(), false);
		} while(dfs(src, dest, vert_limit));
		
		if(flow == K) {
			cout << lvls << "\n";
			
			fill(visited.begin(), visited.end(), false);
			
			vector<vector<pair<int, int>>> W(lvls);
			for(int i = 0; i < K; ++i) {
				int p = src;
				int v = S;
				while(true) {
					int lvl = p / verts_per_level;
					int levelp = p - lvl * verts_per_level;
					if(levelp < N && levelp != v) {
						v = levelp;
						W[lvl - 1].emplace_back(i, v);
					}
					if(p == dest) break;
					
					for(Edge& e : G[p]) {
						if(e.flow > 0) {
							--e.flow;
							p = e.dest;
							break;
						}
					}
				}
			}
			
			for(int i = 0; i < lvls; ++i) {
				cout << W[i].size();
				for(auto p : W[i]) {
					cout << ' ' << p.first + 1 << ' ' << p.second + 1;
				}
				cout << "\n";
			}
			
			return 0;
		}
	}
	
	return 0;
}
